abstract class FactorySingleton
{
  protected static FactorySingleton instance;
  protected FactorySingleton() {};

  protected static int nombreBillet;
  
  public abstract Billet creerBillet();
}

class FactoryElectro extends FactorySingleton
{
  private FactoryElectro() {}
  
  public static FactorySingleton getInstance()
  {
    // la ligne suivante est pour permettre de changer la nture de la factory
    // tout en restant singleton.
    //if( instance == null || instance.getClass() != FactoryElectro.class )
    if( instance == null )
      instance = new FactoryElectro();
    return instance;
  }

  public Billet creerBillet()
  {
    return new BilletElectro( ++nombreBillet );
  }
}

class FactoryPapier extends FactorySingleton
{
  private FactoryPapier() {}
  
  public static FactorySingleton getInstance()
  {
    // la ligne suivante est pour permettre de changer la nture de la factory
    // tout en restant singleton.
    //if( instance == null || instance.getClass() != FactoryPapier.class )
    if( instance == null )
      instance = new FactoryPapier();
    return instance;
  }

  public Billet creerBillet()
  {
    return new BilletPapier( ++nombreBillet );
  }
}
